cd "C:\Users\David\Dropbox\Documents\Work\Clients & prospects\GiveWell\Criminal justice\Replications"

use "C:\Users\David\Dropbox\Documents\Work\Library\Sentencing reform\Helland & Tabarrok 2007\all_state_data3 woutofstate" if !inlist(aquit, 1, 2) & inlist(state,5,14,33,44), clear

gen byte violent_arrest = mur_arrest + rap_arrest + asslt_arrest + rob_arrest
gen byte property_arrest = bur_arrest + lar_arrest + mvt_arrest
gen byte index_arrest = violent_arrest + property_arrest
gen byte other_arrest = arrest - index_arrest - drug_arrest
gen byte drug = drugp + drugt + odrug // drug priors = drug posession + drug trafficking + other drug. Crime typology at http://www.icpsr.umich.edu/cgi-bin/file?comp=none&study=3355&ds=1&file_id=1167603&path=NACJD, page 56

label var arrest "All"
label var mur_arrest "Murder"
label var rap_arrest "Rape"
label var asslt_arrest "Assault"
label var rob_arrest "Robbery"
label var bur_arrest "Burglary"
label var lar_arrest "Larceny"
label var mvt_arrest "Vehicle theft"
label var drug_arrest "Drug"
label var index_arrest "Index crime"
label var violent_arrest "Violent"
label var property_arrest "Property"
label var other_arrest "Other"

label define PostalCode 5 CA 14 IL 33 NY 44 TX
label values state PostalCode

gen byte cstrikes = c_strike if inlist(c_strike,1,2) & j_strike==2 


* Tables 1, 3

set scheme s1color
frmttable, clear(table)
foreach state in 5 44 {
	local statename = cond(`state'==5, "California", "Texas")

	* Table 1: balance check table
	frmttable, clear

//	foreach var in murder vol_man veh_man neg_man un_man un_hom kidnap rape osex robb asslt oviol burg larc motor arson fraud sprop oprop drugp drugt odrug weapon dui po { // full list
	foreach var in age age_fa black hisp prir murder robb asslt oviol burg arson weapon drug larc po tot_prison {
		ttest `var' if rectype==4 & state==`state', by(cstrikes)
		mat statmat = r(mu_1), r(sd_1)/sqrt(r(N_1)), r(mu_2), r(sd_2)/sqrt(r(N_2)), r(mu_1)-r(mu_2), r(se), r(p), .
		frmttable, append statmat(statmat) substat(1) nodisplay
	}
	regress cstrikes age age_fa black hisp prir murder robb asslt oviol burg arson weapon drug tot_prison if rectype==4 & state==`state' // joint test
	mat statmat = ., ., ., Ftail(e(df_m), e(df_r), e(F))
	frmttable, append statmat(statmat) nodisplay
	frmttable, replay(table) merge store(table) nodisplay

	preserve
	keep if rectype!=4
	
	local graphnames
	local i 1
	foreach var in arrest index_arrest violent_arrest property_arrest mur_arrest rap_arrest asslt_arrest rob_arrest bur_arrest lar_arrest mvt_arrest drug_arrest other_arrest {
		stset date, id(id) failure(`var') origin(time r_date) exit(time . ) time0(begin) enter(law_date)
		
		local name: variable label `var'
		local graphname `:subinstr local name " " "_", all'`statename'
		local graphnames `graphnames' `graphname'

		stcox age age_fa black hisp male murder rape kidnap robb asslt oviol burg arson weapon c_strike#state if j_strike==2 & (c_strike==1 | c_strike==2), cluster(id)

		sts graph if state==`state', by(cstrikes) ///
			title(`"`name': impact=`=string((exp(_b[2.c_strike#5.state])-1)*100,"%4.1f")'% se=`=string(100*exp(_b[2.c_strike#5.state])*_se[2.c_strike#5.state],"%4.1f")'% p=`=string(2*(1-normal(abs(_b[2.c_strike#5.state]/_se[2.c_strike#5.state]))),"%3.2f")'"', size(medlarge) span) ///
			legend(`=cond("`var'"!="mvt_arrest","off", `"cols(1) ring(0) position(7) region(lwidth(none)) label(1 "Two trials, one strike") label(2 "Two trials, two strikes") order(2 1) size(large)"')') ///
			ytitle(`"`=cond(mod(`++i',3)==2,"Share not arrested"," ")'"') ///
			xtitle(`"`=cond(`i'>10,"Days since release"," ")'"') ///
			`=cond(`i'<=10, `"xlabel("")"', "")' ///
			plotregion(style(none)) graphregion(margin(zero)) ylabel(`=cond(mod(`i',3)==2, `".5 "50%" .75 "75%" 1 "100%""', `""""')', nogrid angle(hor)) ///
			yscale(range(.5 1)) ///
			plot1opts(lpat(solid)) plot2opts(lpat(dash)) plotopts(lcolor(black)) ///
			name(`graphname', replace)
	}
	restore
	local arrest All`statename'
	local other_arrest Other`statename'
	graph combine `:list graphnames - arrest'      , name(`statename', replace) cols(3) graphregion(margin(none)) // Open Phil report version
	graph export "Helland & Tabarrok by crime `statename'.png", width(1000) replace
	graph combine `:list graphnames - other_arrest', name(`statename', replace) cols(3) graphregion(margin(none)) // journal version
	graph export "Helland & Tabarrok by crime `statename' journal.png", width(1000) replace
}
frmttable using "Helland & Tabarrok", replace replay(table) // balance check table
